<!-- new opponent -->
<div class="modal fade modal--shadow" id="manage-meeting" role="dialog" tabindex="-1" wire:ignore.self>
    <div class="modal-dialog modal-xl modal-dialog-centered" role="document" style="max-width: 1250px !important">
        <div class="modal-content">


            
            <div class="modal-body py-0 px-0 rtl--direction">





                
                <header class="modal--header px-4">
                    <h5 class="mb-0 fw-bold text-white"><?php echo e(__('Manage Meeting')); ?></h5>

                    <button class="btn btn--raw-icon w-auto btn--close" data-bs-toggle="tooltip" data-bss-tooltip=""
                        data-bs-placement="<?php echo e(__('right')); ?>" data-bs-dismiss="modal" type="button"
                        title="<?php echo e(__('Close Modal')); ?>">
                        <svg class="bi bi-dash-lg fs-1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em"
                            fill="currentColor" viewBox="0 0 16 16">
                            <path fill-rule="evenodd" d="M2 8a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11A.5.5 0 0 1 2 8Z">
                            </path>
                        </svg>
                    </button>
                </header>
                








                
                










                
                <div class="px-4 pt-4">
                    <div class="row mx-0 mb-5">








                        
                        <div class="col-6">
                            <div class="row mx-2 justify-content-center">






                                
                                <div class="col-8">


                                    <div class="d-flex align-items-center justify-content-between mb-1">
                                        <hr style="width: 55%;" />
                                        <label class="form-label form--label px-3 w-50 text-center mb-0"><?php echo e(__('Meeting Status')); ?></label>
                                    </div>



                                    <div class="select--single-wrapper mb-4" wire:ignore>
                                        <select id='meeting-status-select-2'
                                            class="form-select form--select2 init--modal-select init--modal-manage-meeting-status-select"
                                            data-instance='meetingStatus' data-modal='#manage-meeting' required>
                                            <option value=""></option>
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $statuses ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($status); ?>"><?php echo e(__($status)); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                        </select>
                                    </div>
                                </div>









                                
                                








                                
                                <div class="col-12 mb-2 text-center">



                                    
                                    <button
                                        class="btn btn-outline-warning px-4 py-1 d-inline-flex align-items-center mx-1 btn--action btn--icon"
                                        type="button" wire:loading>
                                        <i class="bi bi-printer me-2"></i><?php echo e(__('Print')); ?></button>




                                    
                                    <button
                                        class="btn btn-outline-warning px-4 py-1 d-inline-flex align-items-center mx-1 btn--action btn--icon"
                                        type="button" wire:loading>
                                        <i class="bi bi-envelope-at me-2"></i><?php echo e(__('Send via Email')); ?></button>




                                </div>
                                






                                
                                








                                
                                <div class="col-12 mb-5 text-center">



                                    
                                    <button wire:click='manageUpcoming(<?php echo e($meeting?->id); ?>)' data-bs-toggle='modal'
                                        data-bs-target='#upcoming-meeting'
                                        class="btn btn--scheme-5 px-4 py-1 d-inline-flex align-items-center mx-1 btn--action btn--icon text-white"
                                        type="button" wire:loading><?php echo e(__('Upcoming Meeting')); ?></button>


                                </div>











                                
                                












                                
                                <div class="col-12 row--section">




                                    
                                    <h6 class="row--section-title extra-padding small"><?php echo e(__('Participants')); ?></h6>






                                    
                                    <form class="row pt-3 align-items-center" wire:submit='storeParticipant'
                                        wire:loading.class='disabled'
                                        wire:target='storeParticipant, translateParticipant'>









                                        
                                        <div class="col-6">
                                            <label class="form-label form--label"><?php echo e(__('Job Title')); ?></label>

                                            <div class="select--single-wrapper mb-4" wire:ignore>
                                                <select
                                                    class="form-select form--select2 init--modal-select init--modal-manage-meeting-select"
                                                    data-instance='instanceParticipant.jobTitleId'
                                                    data-modal='#manage-meeting' required>
                                                    <option value=""></option>
                                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $jobTitles ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jobTitle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($jobTitle->id); ?>">
                                                        <?php echo e($jobTitle?->{__('name')}); ?>

                                                    </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                </select>
                                            </div>
                                        </div>









                                        
                                        <div class="col-6">
                                            <label class="form-label form--label"><?php echo e(__('Authority')); ?></label>

                                            <div class="select--single-wrapper mb-4" wire:ignore>
                                                <select
                                                    class="form-select form--select2 init--modal-select init--modal-manage-meeting-select"
                                                    data-instance='instanceParticipant.authority'
                                                    data-modal='#manage-meeting' required>
                                                    <option value=""></option>
                                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $authorities ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $authority): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($authority); ?>">
                                                        <?php echo e(__($authority)); ?>

                                                    </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                </select>
                                            </div>
                                        </div>







                                        
                                        







                                        
                                        <div class="col-6">
                                            <label class="form-label form--label"><?php echo e(__('Name')); ?></label>
                                            <input class="form-control form--input mb-4" type="text" required
                                                wire:change="translateParticipant('nameAr', 'name', 'en')"
                                                wire:model='instanceParticipant.nameAr' />
                                        </div>


                                        <div class="col-6">
                                            <label class="form-label form--label"><?php echo e(__('Name in English')); ?></label>
                                            <input class="form-control form--input mb-4" type="text" required
                                                wire:change="translateParticipant('name', 'nameAr', 'ar')"
                                                wire:model='instanceParticipant.name' />
                                        </div>










                                        
                                        <div class="col-12 text-center mb-4 position-relative">

                                            
                                            <span
                                                class="spinner-border spinner-border-sm text-success spinner--float-right"
                                                role="status" wire:loading
                                                wire:target='storeParticipant, removeParticipant, translateParticipant'></span>






                                            
                                            <button
                                                class="btn btn--scheme btn--scheme-3 px-5 scalemix--3 py-1 d-inline-flex align-items-center mx-1 scale--self-05"
                                                type="submit" wire:loading
                                                wire:target='storeParticipant, removeParticipant, translateParticipant'>
                                                <?php echo e(__('Append')); ?></button>



                                        </div>
                                    </form>
                                    











                                    
                                    
                                    
                                    








                                    



                                    
                                    <div class="row mb-4 align-items-center">
                                        <div class="col-12">
                                            <div class="table-responsive memoir--table">
                                                <table class="table table-bordered" id="memoir--table">




                                                    
                                                    <thead>
                                                        <tr>
                                                            <th class='th--xs'></th>
                                                            <th><?php echo e(__('Name')); ?></th>
                                                            <th><?php echo e(__('Job Title')); ?></th>
                                                            <th class='th--xs'></th>
                                                        </tr>
                                                    </thead>
                                                    




                                                    
                                                    







                                                    
                                                    <tbody>


                                                        
                                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $participants ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $participant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                                                        <tr key='meeting-participant-<?php echo e($participant->id); ?>'>




                                                            
                                                            <td class='fw-semibold'><?php echo e($globalSNCounter++); ?></td>
                                                            <td><?php echo e($participant?->{__('name')}); ?></td>
                                                            <td><?php echo e($participant?->jobTitle?->{__('name')}); ?></td>





                                                            
                                                            





                                                            
                                                            <td>
                                                                <button class="btn btn--raw-icon scale--3" type="button"
                                                                    wire:loading.attr='disabled'
                                                                    wire:click='removeParticipant(<?php echo e($participant?->id); ?>)'>
                                                                    <svg class="bi bi-trash fs-5"
                                                                        style="fill: var(--delete-color)"
                                                                        xmlns="http://www.w3.org/2000/svg" width="1em"
                                                                        height="1em" fill="currentColor"
                                                                        viewBox="0 0 16 16">
                                                                        <path
                                                                            d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6z">
                                                                        </path>
                                                                        <path fill-rule="evenodd"
                                                                            d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118zM2.5 3V2h11v1h-11z">
                                                                        </path>
                                                                    </svg>
                                                                </button>
                                                            </td>




                                                        </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                        




                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    




                                </div>
                                





















                                
                                
                                
                                
                                
                                
                                
                                
                                




                                
                                <div class="col-12 mt-5 mb-4"></div>











                                
                                <div class="col-12 row--section">



                                    
                                    <h6 class="row--section-title extra-padding small"><?php echo e(__('Agendas')); ?></h6>









                                    
                                    <form class="row pt-3 align-items-center" wire:submit='storeAgenda'
                                        wire:loading.class='disabled' wire:target='storeAgenda, translateAgenda'>







                                        
                                        <div class="col-6">
                                            <label class="form-label form--label"><?php echo e(__('Agenda')); ?></label>
                                            <input class="form-control form--input mb-4" type="text" required
                                                wire:change="translateAgenda('informationAr', 'information', 'en')"
                                                wire:model='instanceAgenda.informationAr' />
                                        </div>



                                        <div class="col-6">
                                            <label class="form-label form--label"><?php echo e(__('Agenda in English')); ?></label>
                                            <input class="form-control form--input mb-4" type="text" required
                                                wire:change="translateAgenda('information', 'informationAr', 'ar')"
                                                wire:model='instanceAgenda.information' />
                                        </div>





                                        
                                        <div class="col-6">
                                            <label class="form-label form--label"><?php echo e(__('Presenter Name')); ?></label>
                                            <input class="form-control form--input mb-4" type="text" required
                                                wire:change="translateAgenda('presenterAr', 'presenter', 'en')"
                                                wire:model='instanceAgenda.presenterAr' />
                                        </div>




                                        
                                        <div class="col-6">
                                            <label class="form-label form--label"><?php echo e(__('Presenter Name in English')); ?></label>
                                            <input class="form-control form--input mb-4" type="text" required
                                                wire:change="translateAgenda('presenter', 'presenterAr', 'ar')"
                                                wire:model='instanceAgenda.presenter' />
                                        </div>








                                        
                                        <div class="col-12 text-center position-relative mb-4">

                                            
                                            <span
                                                class="spinner-border spinner-border-sm text-success spinner--float-right"
                                                role="status" wire:loading
                                                wire:target='storeAgenda, removeAgenda, translateAgenda'></span>





                                            
                                            <button
                                                class="btn btn--scheme btn--scheme-3 px-5 scalemix--3 py-1 d-inline-flex align-items-center mx-1 scale--self-05"
                                                type="submit" wire:loading
                                                wire:target='storeAgenda, removeAgenda, translateAgenda'>
                                                <?php echo e(__('Append')); ?></button>


                                        </div>


                                    </form>
                                    









                                    
                                    
                                    
                                    






                                    



                                    
                                    <div class="row mb-4 align-items-center">
                                        <div class="col-12">
                                            <div class="table-responsive memoir--table">
                                                <table class="table table-bordered" id="memoir--table">




                                                    
                                                    <thead>
                                                        <tr>
                                                            <th class='th--xs'></th>
                                                            <th><?php echo e(__('Agendas')); ?></th>
                                                            <th><?php echo e(__('Presenter')); ?></th>
                                                            <th class='th--xs'></th>
                                                        </tr>
                                                    </thead>
                                                    




                                                    
                                                    



                                                    
                                                    <?php $globalSNCounter = 1; ?>







                                                    
                                                    <tbody>


                                                        
                                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $agendas ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agenda): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                                                        <tr key='meeting-agenda-<?php echo e($agenda->id); ?>'>




                                                            
                                                            <td class='fw-semibold'><?php echo e($globalSNCounter++); ?></td>
                                                            <td><?php echo e($agenda?->{__('information')}); ?></td>
                                                            <td><?php echo e($agenda?->{__('presenter')}); ?></td>





                                                            
                                                            





                                                            
                                                            <td>
                                                                <button class="btn btn--raw-icon scale--3" type="button"
                                                                    wire:loading.attr='disabled'
                                                                    wire:click='removeAgenda(<?php echo e($agenda?->id); ?>)'>
                                                                    <svg class="bi bi-trash fs-5"
                                                                        style="fill: var(--delete-color)"
                                                                        xmlns="http://www.w3.org/2000/svg" width="1em"
                                                                        height="1em" fill="currentColor"
                                                                        viewBox="0 0 16 16">
                                                                        <path
                                                                            d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6z">
                                                                        </path>
                                                                        <path fill-rule="evenodd"
                                                                            d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118zM2.5 3V2h11v1h-11z">
                                                                        </path>
                                                                    </svg>
                                                                </button>
                                                            </td>




                                                        </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                        




                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    







                                </div>
                                



















                                
                                
                                
                                
                                
                                
                                
                                
                                




                                
                                <div class="col-12 mt-5 mb-4"></div>











                                
                                <div class="col-12 row--section">



                                    
                                    <h6 class="row--section-title extra-padding small"><?php echo e(__('Conclusion')); ?></h6>







                                    
                                    <form class="row pt-3 align-items-center" wire:submit='updateConclusion'
                                        wire:loading.class='disabled'
                                        wire:target='updateConclusion, translateConclusion'>






                                        
                                        <div class="col-12">
                                            <label class="form-label form--label"><?php echo e(__('Conclusion')); ?></label>
                                            <textarea class="form-control form--input form--textarea  mb-4" required
                                                wire:change="translateConclusion('conclusionAr', 'conclusion', 'en')"
                                                wire:model='instanceConclusion.conclusionAr'></textarea>
                                        </div>




                                        <div class="col-12">
                                            <label class="form-label form--label"><?php echo e(__('Conclusion in English')); ?></label>
                                            <textarea class="form-control form--input form--textarea  mb-4" required
                                                wire:change="translateConclusion('conclusion', 'conclusionAr', 'ar')"
                                                wire:model='instanceConclusion.conclusion'></textarea>
                                        </div>











                                        
                                        <div class="col-12 text-center position-relative mb-4">

                                            
                                            <span
                                                class="spinner-border spinner-border-sm text-success spinner--float-right"
                                                role="status" wire:loading
                                                wire:target='updateConclusion, translateConclusion'></span>





                                            
                                            <button
                                                class="btn btn--scheme btn--scheme-3 px-5 scalemix--3 py-1 d-inline-flex align-items-center mx-1 scale--self-05"
                                                type="submit" wire:loading
                                                wire:target='updateConclusion, translateConclusion'>
                                                <?php echo e(__('Update')); ?></button>


                                        </div>
                                    </form>
                                    






                                </div>
                            </div>
                        </div>
                        








                        
                        










                        
                        <div class="col-6">
                            <div class="row justify-content-center  mx-2">
















                                
                                



                                
                                <div class="col-12 mb-5"></div>









                                
                                <div class="col-12 row--section">



                                    
                                    <h6 class="row--section-title extra-padding small"><?php echo e(__('Discussion Points')); ?>

                                    </h6>





                                    
                                    <form class="row pt-3 align-items-center" wire:submit='storeDiscussion'
                                        wire:loading.class='disabled'
                                        wire:target='storeDiscussion, translateDiscussion'>







                                        
                                        <div class="col-12">
                                            <label class="form-label form--label"><?php echo e(__('Discussion Point')); ?></label>
                                            <textarea class="form-control form--input form--textarea  mb-4" required
                                                wire:change="translateDiscussion('pointAr', 'point', 'en')"
                                                wire:model='instanceDiscussion.pointAr'></textarea>
                                        </div>




                                        <div class="col-12">
                                            <label class="form-label form--label"><?php echo e(__('Discussion Point in English')); ?></label>
                                            <textarea class="form-control form--input form--textarea  mb-4" required
                                                wire:change="translateDiscussion('point', 'pointAr', 'ar')"
                                                wire:model='instanceDiscussion.point'></textarea>
                                        </div>






                                        
                                        








                                        
                                        <div class="col-6">
                                            <label class="form-label form--label"><?php echo e(__('Note')); ?></label>
                                            <textarea class="form-control form--input form--textarea mb-4" wire
                                                wire:change="translateDiscussion('noteAr', 'note', 'en')"
                                                wire:model='instanceDiscussion.noteAr'></textarea>

                                        </div>



                                        <div class="col-6">
                                            <label class="form-label form--label"><?php echo e(__('Note in English')); ?></label>

                                            <textarea class="form-control form--input form--textarea mb-4"
                                                wire:change="translateDiscussion('note', 'noteAr', 'ar')"
                                                wire:model='instanceDiscussion.note'></textarea>
                                        </div>








                                        
                                        <div class="col-12 text-center position-relative mb-4">

                                            
                                            <span
                                                class="spinner-border spinner-border-sm text-success spinner--float-right"
                                                role="status" wire:loading
                                                wire:target='storeDiscussion, removeDiscussion, translateDiscussion'></span>





                                            
                                            <button
                                                class="btn btn--scheme btn--scheme-3 px-5 scalemix--3 py-1 d-inline-flex align-items-center mx-1 scale--self-05"
                                                type="submit" wire:loading
                                                wire:target='storeDiscussion, removeDiscussion, translateDiscussion'>
                                                <?php echo e(__('Append')); ?></button>


                                        </div>


                                    </form>
                                    









                                    
                                    
                                    
                                    






                                    



                                    
                                    <div class="row mb-4 align-items-center">
                                        <div class="col-12">
                                            <div class="table-responsive memoir--table">
                                                <table class="table table-bordered" id="memoir--table">




                                                    
                                                    <thead>
                                                        <tr>
                                                            <th class='th--xs'></th>
                                                            <th class='th--xl'><?php echo e(__('Discussion Point')); ?></th>
                                                            <th class='th--md'><?php echo e(__('Note')); ?></th>
                                                            <th class='th--xs'></th>
                                                        </tr>
                                                    </thead>
                                                    




                                                    
                                                    



                                                    
                                                    <?php $globalSNCounter = 1; ?>








                                                    
                                                    <tbody>


                                                        
                                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $discussions ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $discussion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                                                        <tr key='meeting-discussion-<?php echo e($discussion->id); ?>'>




                                                            
                                                            <td class='fw-semibold'><?php echo e($globalSNCounter++); ?></td>
                                                            <td><?php echo e($discussion?->{__('point')}); ?></td>
                                                            <td><?php echo e($discussion?->{__('note')}); ?></td>





                                                            
                                                            





                                                            
                                                            <td>
                                                                <button class="btn btn--raw-icon scale--3" type="button"
                                                                    wire:loading.attr='disabled'
                                                                    wire:click='removeDiscussion(<?php echo e($discussion?->id); ?>)'>
                                                                    <svg class="bi bi-trash fs-5"
                                                                        style="fill: var(--delete-color)"
                                                                        xmlns="http://www.w3.org/2000/svg" width="1em"
                                                                        height="1em" fill="currentColor"
                                                                        viewBox="0 0 16 16">
                                                                        <path
                                                                            d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6z">
                                                                        </path>
                                                                        <path fill-rule="evenodd"
                                                                            d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118zM2.5 3V2h11v1h-11z">
                                                                        </path>
                                                                    </svg>
                                                                </button>
                                                            </td>




                                                        </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                        




                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    







                                </div>
                                


















                                
                                



                                
                                <div class="col-12 mt-4 mb-5"></div>









                                
                                <div class="col-12 row--section">



                                    
                                    <h6 class="row--section-title extra-padding small"><?php echo e(__('Action Plans')); ?>

                                    </h6>





                                    
                                    <form class="row pt-3 align-items-center" wire:submit='storeAction'
                                        wire:loading.class='disabled' wire:target='storeAction, translateAction'>





                                        
                                        <div class="col-6 position-relative d-none">
                                            <label class="form-label form--label"><?php echo e(__('Handler')); ?></label>

                                            <div class="select--single-wrapper mb-4" wire:ignore>
                                                <select id='meeting-handler-select-2'
                                                    class="form-select form--select2 init--modal-select init--modal-manage-meeting-select"
                                                    data-instance='instanceAction.handlerId'
                                                    data-modal='#manage-meeting'>
                                                    <option value=""></option>
                                                </select>
                                            </div>
                                        </div>






                                        
                                        








                                        
                                        <div class="col-6">
                                            <label class="form-label form--label"><?php echo e(__('Information')); ?></label>
                                            <textarea class="form-control form--input form--textarea  mb-4" required
                                                wire:change="translateAction('informationAr', 'information', 'en')"
                                                wire:model='instanceAction.informationAr'></textarea>
                                        </div>




                                        <div class="col-6">
                                            <label class="form-label form--label"><?php echo e(__('Information in English')); ?></label>
                                            <textarea class="form-control form--input form--textarea  mb-4" required
                                                wire:change="translateAction('information', 'informationAr', 'ar')"
                                                wire:model='instanceAction.information'></textarea>
                                        </div>









                                        
                                        








                                        
                                        <div class="col-12 text-center position-relative mb-4">

                                            
                                            <span
                                                class="spinner-border spinner-border-sm text-success spinner--float-right"
                                                role="status" wire:loading
                                                wire:target='storeAction, removeAction, translateAction'></span>





                                            
                                            <button
                                                class="btn btn--scheme btn--scheme-3 px-5 scalemix--3 py-1 d-inline-flex align-items-center mx-1 scale--self-05"
                                                type="submit" wire:loading
                                                wire:target='storeAction, removeAction, translateAction'>
                                                <?php echo e(__('Append')); ?></button>


                                        </div>


                                    </form>
                                    









                                    
                                    
                                    
                                    






                                    



                                    
                                    <div class="row mb-4 align-items-center">
                                        <div class="col-12">
                                            <div class="table-responsive memoir--table">
                                                <table class="table table-bordered" id="memoir--table">




                                                    
                                                    <thead>
                                                        <tr>
                                                            <th class='th--xs'></th>
                                                            <th class='th--xl'><?php echo e(__('Action Plan')); ?></th>
                                                            <th class='th--xs'></th>
                                                        </tr>
                                                    </thead>
                                                    






                                                    
                                                    



                                                    
                                                    <?php $globalSNCounter = 1; ?>








                                                    
                                                    <tbody>


                                                        
                                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $actions ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                                                        <tr key='meeting-action-<?php echo e($action->id); ?>'>




                                                            
                                                            <td class='fw-semibold'><?php echo e($globalSNCounter++); ?></td>
                                                            <td><?php echo e($action?->{__('information')}); ?></td>





                                                            
                                                            





                                                            
                                                            <td>
                                                                <button class="btn btn--raw-icon scale--3" type="button"
                                                                    wire:loading.attr='disabled'
                                                                    wire:click='removeAction(<?php echo e($action?->id); ?>)'>
                                                                    <svg class="bi bi-trash fs-5"
                                                                        style="fill: var(--delete-color)"
                                                                        xmlns="http://www.w3.org/2000/svg" width="1em"
                                                                        height="1em" fill="currentColor"
                                                                        viewBox="0 0 16 16">
                                                                        <path
                                                                            d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6z">
                                                                        </path>
                                                                        <path fill-rule="evenodd"
                                                                            d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118zM2.5 3V2h11v1h-11z">
                                                                        </path>
                                                                    </svg>
                                                                </button>
                                                            </td>




                                                        </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                        




                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    







                                </div>
                                







                            </div>
                        </div>
                        



                    </div>
                </div>
                












                
                







            </div>
        </div>
    </div>
    



















    
    






    
    <script>
        $(".init--modal-manage-meeting-select").on("change", function(event) {


            // 1.1: getValue - instance
            selectValue = $(this).select2('val');
            instance = $(this).attr('data-instance');

            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set(instance, selectValue);

        }); //end function
    </script>










    
    <script>
        $(".init--modal-manage-meeting-status-select").on("change", function(event) {


            // 1.1: getValue - instance
            selectValue = $(this).select2('val');
            instance = $(this).attr('data-instance');


            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set(instance, selectValue);
            window.Livewire.find('<?php echo e($_instance->getId()); ?>').updateStatus(selectValue);


        }); //end function
    </script>









    
    







</div>
<?php /**PATH /home/lawfirmadmin/public_html/lfm/resources/views/livewire/dashboard/files/single-file/components/single-file-meetings-manage.blade.php ENDPATH**/ ?>