<!-- new document -->
<div class="modal fade modal--shadow" id="execution-invoices" role="dialog" tabindex="-1" wire:ignore.self>
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body py-0 px-0 rtl--direction">




                
                <header class="modal--header px-4">
                    <h5 class="mb-0 fw-bold text-white"><?php echo e(__('Invoices')); ?></h5>
                    <button class="btn btn--raw-icon w-auto btn--close" data-bs-toggle="tooltip" data-bss-tooltip=""
                        data-bs-placement="<?php echo e(__('right')); ?>" data-bs-dismiss="modal" type="button"
                        title="<?php echo e(__('Close Modal')); ?>">
                        <svg class="bi bi-dash-lg fs-1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em"
                            fill="currentColor" viewBox="0 0 16 16">
                            <path fill-rule="evenodd" d="M2 8a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11A.5.5 0 0 1 2 8Z">
                            </path>
                        </svg>
                    </button>
                </header>
                






                
                







                
                <form class="px-4" wire:submit='store' wire:loading.class='disabled'
                    wire:target='store, instance.documentFile, translate'>
                    <div class="row pt-2 align-items-center mb-4">




                        
                        <div class="col-6">
                            <label class="form-label form--label"><?php echo e(__('Invoice Title')); ?></label>
                            <input class="form-control form--input mb-4 " type="text"
                                wire:change="translate('titleAr', 'title', 'en')" wire:model='instance.titleAr'
                                required />
                        </div>


                        <div class="col-6">
                            <label class="form-label form--label"><?php echo e(__('Invoice Title in English')); ?></label>
                            <input class="form-control form--input mb-4 " type="text"
                                wire:change="translate('title', 'titleAr', 'ar')" wire:model='instance.title'
                                required />
                        </div>







                        
                        





                        <div class="col-6">
                            <label class="form-label form--label"><?php echo e(__('Fees')); ?></label>
                            <input class="form-control form--input mb-4 " type="number" step='0.01'
                                wire:model='instance.fees' />
                        </div>







                        
                        <div class="col-6">
                            <label class="form-label form--label"><?php echo e(__('Attachment File')); ?></label>
                            <input class="form-control form--file-input mb-4" id='execution--invoice-file-1' type="file"
                                wire:model='instance.documentFile' required />
                        </div>









                        
                        <div class="col-12 text-center mt-2 d-flex justify-content-center position-relative">


                            
                            <span class="spinner-border spinner-border-sm text-success spinner--float-right"
                                role="status" wire:loading wire:target='store, instance.documentFile, translate'></span>



                            <button
                                class="btn btn--scheme btn--scheme-theme px-5 py-1 d-flex align-items-center justify-content-center  scale--self-05"
                                type="submit" wire:loading.attr='disabled'
                                wire:target='store, instance.documentFile, translate'>
                                <?php echo e(__('Save')); ?>

                            </button>
                        </div>



                    </div>
                </form>
                














                
                
                
                
                












                
                <div class="row mb-4 px-4 mt-4 align-items-center">



                    
                    <div class="col-12">
                        <div class="table-responsive memoir--table">
                            <table class="table table-bordered" id="memoir--table">



                                
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Invoice')); ?></th>
                                        <th class='th--lg'><?php echo e(__('Date')); ?></th>
                                        <th class='th--xs'></th>
                                        <th class='th--xs'></th>
                                    </tr>
                                </thead>
                                






                                
                                







                                
                                <tbody>


                                    
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $invoices ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                                    <tr key='single-execution-invoice-<?php echo e($invoice->id); ?>'>




                                        
                                        <td><?php echo e($invoice?->{__('title')}); ?></td>
                                        <td><?php echo e(date('d / m / Y', strtotime($invoice->creationDate))); ?></td>







                                        
                                        







                                        
                                        <td>


                                            
                                            <!--[if BLOCK]><![endif]--><?php if($invoice->documentFile): ?>



                                            <button wire:loading.attr='disabled' wire:target='remove, download'
                                                wire:click='download(<?php echo e($invoice->id); ?>)'
                                                class="btn btn--scheme btn--scheme-3 fs-12 mx-1 scale--3 px-2 py-1"
                                                type="button">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em"
                                                    fill="currentColor" viewBox="0 0 16 16"
                                                    class="bi bi-save fs-6 me-2">
                                                    <path
                                                        d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H9.5a1 1 0 0 0-1 1v7.293l2.646-2.647a.5.5 0 0 1 .708.708l-3.5 3.5a.5.5 0 0 1-.708 0l-3.5-3.5a.5.5 0 1 1 .708-.708L7.5 9.293V2a2 2 0 0 1 2-2H14a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h2.5a.5.5 0 0 1 0 1H2z">
                                                    </path>
                                                </svg><?php echo e(__('Download')); ?>

                                            </button>






                                            
                                            <?php else: ?>

                                            <button disabled
                                                class="btn btn--scheme btn--scheme-3 fs-12 mx-1 scale--3 px-2 py-1"
                                                type="button">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em"
                                                    fill="currentColor" viewBox="0 0 16 16"
                                                    class="bi bi-save fs-6 me-2">
                                                    <path
                                                        d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H9.5a1 1 0 0 0-1 1v7.293l2.646-2.647a.5.5 0 0 1 .708.708l-3.5 3.5a.5.5 0 0 1-.708 0l-3.5-3.5a.5.5 0 1 1 .708-.708L7.5 9.293V2a2 2 0 0 1 2-2H14a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h2.5a.5.5 0 0 1 0 1H2z">
                                                    </path>
                                                </svg><?php echo e(__('Download')); ?>

                                            </button>


                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            




                                        </td>




                                        
                                        







                                        
                                        <td>
                                            <button class="btn btn--raw-icon scale--3" type="button"
                                                wire:loading.attr='disabled' wire:click='remove(<?php echo e($invoice->id); ?>)'>
                                                <svg class="bi bi-trash fs-5" style="fill: var(--delete-color)"
                                                    xmlns="http://www.w3.org/2000/svg" width="1em" height="1em"
                                                    fill="currentColor" viewBox="0 0 16 16">
                                                    <path
                                                        d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6z">
                                                    </path>
                                                    <path fill-rule="evenodd"
                                                        d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118zM2.5 3V2h11v1h-11z">
                                                    </path>
                                                </svg>
                                            </button>
                                        </td>


                                    </tr>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    




                                </tbody>
                            </table>
                        </div>
                    </div>
                    

                </div>
                






            </div>
        </div>
    </div>
    








</div>
<?php /**PATH /home/lawfirmadmin/public_html/lfm/resources/views/livewire/dashboard/execution-files/single-execution-file/components/single-execution-file-invoices.blade.php ENDPATH**/ ?>