<!-- new opponent -->
<div class="modal fade modal--shadow" id="edit-configurations" role="dialog" tabindex="-1" wire:ignore.self>
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body py-0 px-0 rtl--direction">






                
                <header class="modal--header px-4">
                    <h5 class="mb-0 fw-bold text-white"><?php echo e(__('Case Configurations')); ?></h5>

                    <button class="btn btn--raw-icon w-auto" data-bs-toggle="tooltip" data-bss-tooltip=""
                        data-bs-placement="<?php echo e(__('right')); ?>" data-bs-dismiss="modal" type="button"
                        title="<?php echo e(__('Close Modal')); ?>">
                        <svg class="bi bi-dash-lg fs-1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em"
                            fill="currentColor" viewBox="0 0 16 16">
                            <path fill-rule="evenodd" d="M2 8a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11A.5.5 0 0 1 2 8Z">
                            </path>
                        </svg>
                    </button>
                </header>
                






                
                










                
                <div class="px-4">

                    <form class="row pt-2 align-items-center" wire:submit='store' wire:ignore
                        wire:loading.class='disabled' wire:target='store, translate, instance.requirementFile'>





                        
                        <div class="col-4">
                            <label class="form-label form--label"><?php echo e(__('Name')); ?></label>
                            <input class="form-control form--input mb-4" type="text" wire:loading.attr='disabled'
                                wire:change="translate('requirementNameAr', 'requirementName', 'en')"
                                wire:model='instance.requirementNameAr' required />
                        </div>





                        <div class="col-4">
                            <label class="form-label form--label"><?php echo e(__('Name in English')); ?></label>
                            <input class="form-control form--input mb-4" type="text" wire:loading.attr='disabled'
                                wire:change="translate('requirementName', 'requirementNameAr', 'ar')"
                                wire:model='instance.requirementName' required />
                        </div>






                        
                        







                        
                        <div class="col-4">
                            <label class="form-label form--label"><?php echo e(__('Requirement Date')); ?></label>
                            <input class="form-control form--input mb-4" type="text" value="<?php echo e(date('d / m / Y')); ?>"
                                readonly />
                        </div>







                        
                        <div class="col-4">
                            <label class="form-label form--label"><?php echo e(__('Information')); ?></label>
                            <input class="form-control form--input mb-4" type="text" wire:loading.attr='disabled'
                                wire:change="translate('requirementInformationAr', 'requirementInformation', 'en')"
                                wire:model='instance.requirementInformationAr' />
                        </div>




                        <div class="col-4">
                            <label class="form-label form--label"><?php echo e(__('Information in English')); ?></label>
                            <input class="form-control form--input mb-4" type="text" wire:loading.attr='disabled'
                                wire:change="translate('requirementInformation', 'requirementInformationAr', 'ar')"
                                wire:model='instance.requirementInformation' />
                        </div>








                        
                        







                        
                        <div class="col-4">
                            <label class="form-label form--label"><?php echo e(__('Assign To')); ?></label>

                            <div class="select--single-wrapper mb-4" wire:ignore>
                                <select class="form-select form--select2 init--modal-select init--modal-config-select"
                                    data-formItem='instance.handlerId' data-modal='#edit-configurations' required>
                                    <option value=""></option>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>">
                                        <?php echo e(__(':text',['text' => $user->name, 'textAr' =>
                                        $user->nameAr])); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </select>
                            </div>
                        </div>


                        <div class="col-8">
                            <label class="form-label form--label"><?php echo e(__('Requirement File')); ?></label>
                            <input class="form-control form--file-input mb-4" id='requirement--file-1' type="file"
                                wire:model='instance.requirementFile' />
                        </div>








                        
                        






                        
                        <div class="col-4 text-center position-relative">

                            
                            <span class="spinner-border spinner-border-sm text-success spinner--float-right"
                                role="status" wire:loading
                                wire:target='store, translate, instance.requirementFile'></span>



                            <button
                                class="btn btn--scheme btn--scheme-theme px-4 scalemix--3 py-1 d-inline-flex align-items-center fs-13"
                                type="submit" wire:loading.attr='disabled'
                                wire:target='store, translate, instance.requirementFile'>
                                <svg class="bi bi-plus-circle-dotted fs-6 me-2" xmlns="http://www.w3.org/2000/svg"
                                    width="1em" height="1em" fill="currentColor" viewBox="0 0 16 16">
                                    <path
                                        d="M8 0c-.176 0-.35.006-.523.017l.064.998a7.117 7.117 0 0 1 .918 0l.064-.998A8.113 8.113 0 0 0 8 0zM6.44.152c-.346.069-.684.16-1.012.27l.321.948c.287-.098.582-.177.884-.237L6.44.153zm4.132.271a7.946 7.946 0 0 0-1.011-.27l-.194.98c.302.06.597.14.884.237l.321-.947zm1.873.925a8 8 0 0 0-.906-.524l-.443.896c.275.136.54.29.793.459l.556-.831zM4.46.824c-.314.155-.616.33-.905.524l.556.83a7.07 7.07 0 0 1 .793-.458L4.46.824zM2.725 1.985c-.262.23-.51.478-.74.74l.752.66c.202-.23.418-.446.648-.648l-.66-.752zm11.29.74a8.058 8.058 0 0 0-.74-.74l-.66.752c.23.202.447.418.648.648l.752-.66zm1.161 1.735a7.98 7.98 0 0 0-.524-.905l-.83.556c.169.253.322.518.458.793l.896-.443zM1.348 3.555c-.194.289-.37.591-.524.906l.896.443c.136-.275.29-.54.459-.793l-.831-.556zM.423 5.428a7.945 7.945 0 0 0-.27 1.011l.98.194c.06-.302.14-.597.237-.884l-.947-.321zM15.848 6.44a7.943 7.943 0 0 0-.27-1.012l-.948.321c.098.287.177.582.237.884l.98-.194zM.017 7.477a8.113 8.113 0 0 0 0 1.046l.998-.064a7.117 7.117 0 0 1 0-.918l-.998-.064zM16 8a8.1 8.1 0 0 0-.017-.523l-.998.064a7.11 7.11 0 0 1 0 .918l.998.064A8.1 8.1 0 0 0 16 8zM.152 9.56c.069.346.16.684.27 1.012l.948-.321a6.944 6.944 0 0 1-.237-.884l-.98.194zm15.425 1.012c.112-.328.202-.666.27-1.011l-.98-.194c-.06.302-.14.597-.237.884l.947.321zM.824 11.54a8 8 0 0 0 .524.905l.83-.556a6.999 6.999 0 0 1-.458-.793l-.896.443zm13.828.905c.194-.289.37-.591.524-.906l-.896-.443c-.136.275-.29.54-.459.793l.831.556zm-12.667.83c.23.262.478.51.74.74l.66-.752a7.047 7.047 0 0 1-.648-.648l-.752.66zm11.29.74c.262-.23.51-.478.74-.74l-.752-.66c-.201.23-.418.447-.648.648l.66.752zm-1.735 1.161c.314-.155.616-.33.905-.524l-.556-.83a7.07 7.07 0 0 1-.793.458l.443.896zm-7.985-.524c.289.194.591.37.906.524l.443-.896a6.998 6.998 0 0 1-.793-.459l-.556.831zm1.873.925c.328.112.666.202 1.011.27l.194-.98a6.953 6.953 0 0 1-.884-.237l-.321.947zm4.132.271a7.944 7.944 0 0 0 1.012-.27l-.321-.948a6.954 6.954 0 0 1-.884.237l.194.98zm-2.083.135a8.1 8.1 0 0 0 1.046 0l-.064-.998a7.11 7.11 0 0 1-.918 0l-.064.998zM8.5 4.5a.5.5 0 0 0-1 0v3h-3a.5.5 0 0 0 0 1h3v3a.5.5 0 0 0 1 0v-3h3a.5.5 0 0 0 0-1h-3v-3z">
                                    </path>
                                </svg><?php echo e(__('Create')); ?>

                            </button>
                        </div>





                    </form>
                    








                    
                    
                    
                    
                    












                    
                    <div class="row mb-4 mt-3 align-items-center"
                        key='requirement-configuration-<?php echo e($requirements?->count() ?? 0); ?>'>




                        
                        <div class="col-12">
                            <div class="table-responsive memoir--table">
                                <table class="table table-bordered" id="memoir--table">



                                    
                                    <thead>
                                        <tr>
                                            <th><?php echo e(__('Requirement')); ?></th>
                                            <th><?php echo e(__('Assign To')); ?></th>
                                            <th><?php echo e(__('Information')); ?></th>
                                            <th><?php echo e(__('Status')); ?></th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    






                                    
                                    







                                    
                                    <tbody>


                                        
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $requirements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $requirement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                                        <tr key='single-config-<?php echo e($requirement->id); ?>'>




                                            
                                            <td><?php echo e($requirement->requirementName); ?></td>


                                            
                                            <td><?php echo e(__(':text',['text' => $requirement?->handler?->name, 'textAr'
                                                => $requirement?->handler?->nameAr])); ?></td>



                                            
                                            <td><?php echo e(__(':text',['text' => $requirement->requirementInformation, 'textAr'
                                                => $requirement->requirementInformationAr])); ?></td>





                                            
                                            <td>
                                                <span class="badge badge--scheme-3 fs-11"><?php echo e(__($requirement->requirementStatus)); ?></span>
                                            </td>




                                            
                                            







                                            
                                            <td>
                                                <button class="btn btn--raw-icon scale--3" type="button"
                                                    wire:loading.attr='disabled'
                                                    wire:click='remove(<?php echo e($requirement->id); ?>)'>
                                                    <svg class="bi bi-trash fs-5" style="fill: var(--delete-color)"
                                                        xmlns="http://www.w3.org/2000/svg" width="1em" height="1em"
                                                        fill="currentColor" viewBox="0 0 16 16">
                                                        <path
                                                            d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6z">
                                                        </path>
                                                        <path fill-rule="evenodd"
                                                            d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118zM2.5 3V2h11v1h-11z">
                                                        </path>
                                                    </svg>
                                                </button>
                                            </td>


                                        </tr>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                        




                                    </tbody>
                                </table>
                            </div>
                        </div>
                        

                    </div>
                </div>
                


            </div>
        </div>
    </div>
    











    
    






    
    <script>
        $(".init--modal-config-select").on("change", function(event) {


         // 1.1: getValue - instanceItem
         selectValue = $(this).select2('val');
         formItem = $(this).attr('data-formItem');

         window.Livewire.find('<?php echo e($_instance->getId()); ?>').set(formItem, selectValue);

      }); //end function
    </script>






    
    







</div>
<?php /**PATH C:\xampp\htdocs\TRUTH\LFM\LFM10\resources\views/livewire/dashboard/files/single-file/components/single-file-configurations.blade.php ENDPATH**/ ?>