
<div class="modal fade modal--shadow" id="new-expert-office" role="dialog" tabindex="-1" wire:ignore.self>
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-body px-4">


                
                <form wire:submit='store' wire:loading.class='disabled'
                    wire:target='instance.imageFile, store, translate'>





                    
                    <div class="row pt-2 align-items-center mb-3 rtl--direction">



                        
                        <div class="col-3">
                            <input name="serial" type="hidden" value='<?php echo e($nextSerial); ?>' wire:model='instance.serial'>

                            <h6
                                class="text-center fw-bold badge--theme-light py-1 rounded-1 text-theme px-4 mb-0 d-inline-block">
                                <?php echo e($nextSerial); ?>

                            </h6>
                        </div>








                        
                        <div class="col-6 text-center">
                            <h4 class="mb-0 badge--theme text-white px-4 rounded-1 py-1 d-inline-block fs-5">
                                <?php echo e(__('New Expert Office')); ?>

                            </h4>
                        </div>



                        
                        <div class="col-3 text-end">
                            <button class="btn btn--raw-icon w-auto btn--close" data-bs-toggle="tooltip"
                                data-bss-tooltip="" data-bs-placement="<?php echo e(__('right')); ?>" data-bs-dismiss="modal"
                                type="button" title="<?php echo e(__('Close Modal')); ?>">
                                <svg class="bi bi-dash-lg fs-2" xmlns="http://www.w3.org/2000/svg" width="1em"
                                    height="1em" fill="currentColor" viewBox="0 0 16 16">
                                    <path fill-rule="evenodd"
                                        d="M2 8a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11A.5.5 0 0 1 2 8Z">
                                    </path>
                                </svg>
                            </button>
                        </div>
                    </div>
                    






                    
                    










                    
                    <div class="row pt-2 align-items-center mb-4 rtl--direction">


                        
                        <div class="col-4">
                            <label class="form-label form--label"><?php echo e(__('Created By')); ?></label>
                            <input class="form-control form--input readonly mb-5" type="text" value="<?php echo e(__(':text', ['text' => session('userName'),
                                'textAr' => session('userNameAr')])); ?>" readonly="" />
                        </div>




                        
                        <div class="col-4"></div>





                        
                        <div class="col-4">
                            <label class="form-label form--label"><?php echo e(__('Creation Date')); ?></label>
                            <div class="input--icon ">
                                <svg class="bi bi-calendar4-week" xmlns="http://www.w3.org/2000/svg" width="1em"
                                    height="1em" fill="currentColor" viewBox="0 0 16 16">
                                    <path
                                        d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5zM2 2a1 1 0 0 0-1 1v1h14V3a1 1 0 0 0-1-1H2zm13 3H1v9a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V5z">
                                    </path>
                                    <path
                                        d="M11 7.5a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5v-1zm-3 0a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5v-1zm-2 3a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5v-1zm-3 0a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5v-1z">
                                    </path>
                                </svg>
                                <input class="form-control form--input mb-5 input--bg readonly" type="text"
                                    value="<?php echo e(date('d / m / Y')); ?>" readonly="" />
                            </div>
                        </div>





                        
                        <div class="col-6">
                            <label class="form-label form--label"><?php echo e(__('Full Name')); ?></label>
                            <input class="form-control form--input mb-4" name='nameAr' type="text"
                                wire:loading.attr='disabled' wire:change="translate('nameAr', 'name', 'en')" required
                                wire:model='instance.nameAr' />
                        </div>



                        <div class="col-6">
                            <label class="form-label form--label"><?php echo e(__('Full Name in English')); ?></label>
                            <input class="form-control form--input mb-4" name='name' type="text"
                                wire:loading.attr='disabled' wire:change="translate('name', 'nameAr', 'ar')" required
                                wire:model='instance.name' />
                        </div>










                        
                        







                        
                        <div class="col-4">
                            <label class="form-label form--label"><?php echo e(__('Email Address')); ?></label>
                            <div class="input--icon ">
                                <svg class="bi bi-envelope" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em"
                                    fill="currentColor" viewBox="0 0 16 16">
                                    <path fill-rule="evenodd"
                                        d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V4Zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1H2Zm13 2.383-4.708 2.825L15 11.105V5.383Zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741ZM1 11.105l4.708-2.897L1 5.383v5.722Z">
                                    </path>
                                </svg>
                                <input class="form-control form--input mb-4 input--bg" name='email' type="email"
                                    required wire:model='instance.email' />
                            </div>
                        </div>






                        
                        <div class="col-4">
                            <label class="form-label form--label"><?php echo e(__('Phone Number')); ?></label>
                            <div class="input--icon ">
                                <svg class="bi bi-telephone" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em"
                                    fill="currentColor" viewBox="0 0 16 16">
                                    <path
                                        d="M3.654 1.328a.678.678 0 0 0-1.015-.063L1.605 2.3c-.483.484-.661 1.169-.45 1.77a17.568 17.568 0 0 0 4.168 6.608 17.569 17.569 0 0 0 6.608 4.168c.601.211 1.286.033 1.77-.45l1.034-1.034a.678.678 0 0 0-.063-1.015l-2.307-1.794a.678.678 0 0 0-.58-.122l-2.19.547a1.745 1.745 0 0 1-1.657-.459L5.482 8.062a1.745 1.745 0 0 1-.46-1.657l.548-2.19a.678.678 0 0 0-.122-.58L3.654 1.328zM1.884.511a1.745 1.745 0 0 1 2.612.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.678.678 0 0 0 .178.643l2.457 2.457a.678.678 0 0 0 .644.178l2.189-.547a1.745 1.745 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.634 18.634 0 0 1-7.01-4.42 18.634 18.634 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877L1.885.511z">
                                    </path>
                                </svg>
                                <input class="form-control form--input mb-4 input--bg" name='phone' type="text" required
                                    wire:model='instance.phone' pattern="[0-9]+" />
                            </div>
                        </div>








                        
                        <div class="col-4">
                            <label class="form-label form--label"><?php echo e(__('Password')); ?></label>
                            <div class="input--icon ">
                                <svg class="bi bi-lock" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em"
                                    fill="currentColor" viewBox="0 0 16 16">
                                    <path
                                        d="M8 1a2 2 0 0 1 2 2v4H6V3a2 2 0 0 1 2-2zm3 6V3a3 3 0 0 0-6 0v4a2 2 0 0 0-2 2v5a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2zM5 8h6a1 1 0 0 1 1 1v5a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V9a1 1 0 0 1 1-1z">
                                    </path>
                                </svg>
                                <input class="form-control form--input mb-4 input--bg" name='password' type="password"
                                    required wire:model='instance.password' />
                            </div>
                        </div>








                        
                        








                        
                        <div class="col-6">
                            <label class="form-label form--label"><?php echo e(__('Address')); ?></label>
                            <input class="form-control form--input mb-4" name='addressAr' type="text"
                                wire:change="translate('addressAr', 'address', 'en')" wire:model='instance.addressAr' />
                        </div>


                        <div class="col-6">
                            <label class="form-label form--label"><?php echo e(__('Address in English')); ?></label>
                            <input class="form-control form--input mb-4" name='address' type="text"
                                wire:change="translate('address', 'addressAr', 'ar')" wire:model='instance.address' />
                        </div>







                        
                        







                        
                        <div class="col-12 text-center mt-2 position-relative rtl--direction">

                            
                            <span class="spinner-border spinner-border-sm text-success spinner--float-right"
                                role="status" wire:loading wire:target='instance.imageFile, store, translate'></span>

                            <button
                                class="btn btn--scheme btn--scheme-outline-2 px-4 scalemix--3 py-1 d-inline-flex align-items-center mx-1"
                                data-bs-dismiss="modal" type="button"><?php echo e(__('Cancel')); ?></button>

                            <button
                                class="btn btn--scheme btn--scheme-3 px-5 scalemix--3 py-1 d-inline-flex align-items-center mx-1 scale--self-05"
                                type="submit" wire:loading.attr='disabled'
                                wire:target='store, translate, instance.imageFile'><?php echo e(__('Save')); ?></button>
                        </div>
                        




                    </div>
                </form>
                




            </div>
        </div>
    </div>
    















    
    








    
    <script>
        $(".init--modal-select").on("change", function(event) {


            // 1.1: getValue - instanceItem
            selectValue = $(this).select2('val');
            instance = $(this).attr('data-instance');

            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set(instance, selectValue);

        }); //end function
    </script>









    
    













</div>
<?php /**PATH /home/lawfirmadmin/public_html/lfm/resources/views/livewire/dashboard/expert-offices/components/expert-offices-create.blade.php ENDPATH**/ ?>